/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.renderer.entity;

import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import net.enderkitty.mobilecraft.entity.Entity;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.renderer.Textures;
import net.enderkitty.mobilecraft.renderer.TileFace;
import net.enderkitty.mobilecraft.renderer.entity.EntityRenderer;

public class TntRenderer
extends EntityRenderer {
    public Image terrain;
    public Texture2D terraintex;
    public Appearance appearance = new Appearance();
    public VertexBuffer vb;
    public IndexBuffer ib;

    public void init() {
        this.loadTex();
        this.buildModel();
    }

    public void loadTex() {
        try {
            this.terrain = Textures.tex[2];
            Image2D image2D = new Image2D(99, (Object)this.terrain);
            this.terraintex = new Texture2D(image2D);
            this.terraintex.setFiltering(208, 210);
            this.terraintex.setWrapping(240, 240);
            this.terraintex.setBlending(227);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildModel() {
        Vector<TileFace> faces = new Vector<TileFace>();
        int i = 0;
        while (i < 6) {
            faces.addElement(Tile.tnt.getFaceNoLevel(0, 0, 0, i));
            ++i;
        }
        short[] vertz = new short[faces.size() * 12];
        short[] tex = new short[faces.size() * 8];
        int fc = 0;
        while (fc < faces.size()) {
            TileFace face = (TileFace)faces.elementAt(fc);
            int i2 = 0;
            while (i2 < 12) {
                vertz[fc * 12 + i2] = face.vert[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                tex[fc * 8 + i2] = face.tex[i2];
                ++i2;
            }
            ++fc;
        }
        VertexArray vertArray = new VertexArray(vertz.length / 3, 3, 2);
        vertArray.set(0, vertz.length / 3, vertz);
        VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
        texArray.set(0, tex.length / 2, tex);
        int[] stripLen = new int[faces.size()];
        int i3 = 0;
        while (i3 < stripLen.length) {
            stripLen[i3] = 4;
            ++i3;
        }
        this.vb = new VertexBuffer();
        this.vb.setPositions(vertArray, 1.0f, null);
        this.vb.setTexCoords(0, texArray, 0.0625f, null);
        this.ib = new TriangleStripArray(0, stripLen);
        this.appearance.setTexture(0, this.terraintex);
    }

    public void render(Entity e, float a, Graphics3D gfx3D, Transform t) {
        Transform tform = new Transform(t);
        float rx = e.xo + (e.x - e.xo) * a;
        float ry = e.yo + (e.y - e.yo) * a;
        float rz = e.zo + (e.z - e.zo) * a;
        tform.postTranslate(rx - 0.5f, ry - 0.5f, rz - 0.5f);
        gfx3D.render(this.vb, this.ib, this.appearance, tform);
    }
}

