/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.renderer;

import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.LevelListener;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.renderer.TileFace;

public class LevelRendererOld
implements LevelListener {
    public Level level;
    public Image terrain;
    public Texture2D terraintex;
    public Appearance appearance;
    public VertexBuffer vb;
    public IndexBuffer ib;
    public boolean needBuild;
    public static int updates = 0;

    public LevelRendererOld() {
        this.loadTex();
        this.appearance = new Appearance();
        this.needBuild = true;
    }

    public void loadTex() {
        try {
            this.terrain = Image.createImage((String)"/terrain.png");
            Image2D image2D = new Image2D(99, (Object)this.terrain);
            this.terraintex = new Texture2D(image2D);
            this.terraintex.setFiltering(208, 210);
            this.terraintex.setWrapping(240, 240);
            this.terraintex.setBlending(227);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getTileFaces() {
        Vector<TileFace> faces = new Vector<TileFace>();
        int ix = 0;
        while (ix < this.level.width) {
            int iy = 0;
            while (iy < this.level.depth) {
                int iz = 0;
                while (iz < this.level.height) {
                    int id = this.level.getTile(ix, iy, iz);
                    if (id != 0) {
                        Tile tle = Tile.tiles[id];
                        int f = 0;
                        while (f < 6) {
                            if (tle.isFaceVisible(this.level, ix, iy, iz, f)) {
                                faces.addElement(tle.getFace(this.level, ix, iy, iz, f));
                            }
                            ++f;
                        }
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return faces;
    }

    public void buildRender() {
        ++updates;
        Vector faces = this.getTileFaces();
        System.out.println(String.valueOf(faces.size()) + " faces");
        short[] vertz = new short[faces.size() * 12];
        short[] tex = new short[faces.size() * 8];
        int fc = 0;
        while (fc < faces.size()) {
            TileFace face = (TileFace)faces.elementAt(fc);
            int i = 0;
            while (i < 12) {
                vertz[fc * 12 + i] = face.vert[i];
                ++i;
            }
            i = 0;
            while (i < 8) {
                tex[fc * 8 + i] = face.tex[i];
                ++i;
            }
            ++fc;
        }
        VertexArray vertArray = new VertexArray(vertz.length / 3, 3, 2);
        vertArray.set(0, vertz.length / 3, vertz);
        VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
        texArray.set(0, tex.length / 2, tex);
        int[] stripLen = new int[faces.size()];
        int i = 0;
        while (i < stripLen.length) {
            stripLen[i] = 4;
            ++i;
        }
        this.vb = new VertexBuffer();
        this.vb.setPositions(vertArray, 1.0f, null);
        this.vb.setTexCoords(0, texArray, 0.0625f, null);
        this.ib = new TriangleStripArray(0, stripLen);
        this.appearance.setTexture(0, this.terraintex);
        this.needBuild = false;
    }

    public void checkBuild() {
        if (this.needBuild) {
            this.buildRender();
            this.needBuild = false;
        }
    }

    public void tileChanged(int x, int y, int z) {
        this.needBuild = true;
    }

    public void allChanged() {
        this.needBuild = true;
    }
}

