/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.renderer;

import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.LevelListener;
import net.enderkitty.mobilecraft.renderer.Chunk;
import net.enderkitty.mobilecraft.renderer.Textures;

public class LevelRenderer
implements LevelListener {
    public Level level;
    public Image terrain;
    public Texture2D terraintex;
    public Appearance appearance;
    public Chunk[] chunks;
    public int xChunks;
    public int yChunks;
    public int zChunks;

    public LevelRenderer() {
        this.loadTex();
        this.appearance = new Appearance();
    }

    public void loadTex() {
        try {
            this.terrain = Textures.tex[2];
            Image2D image2D = new Image2D(99, (Object)this.terrain);
            this.terraintex = new Texture2D(image2D);
            this.terraintex.setFiltering(208, 210);
            this.terraintex.setWrapping(240, 240);
            this.terraintex.setBlending(227);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLevel(Level lvl) {
        this.level = lvl;
        this.allChanged();
    }

    public void allChanged() {
        this.xChunks = this.level.width >>> 3;
        this.yChunks = this.level.depth >>> 3;
        this.zChunks = this.level.height >>> 3;
        this.chunks = new Chunk[this.xChunks * this.yChunks * this.zChunks];
        int x = 0;
        while (x < this.xChunks) {
            int y = 0;
            while (y < this.yChunks) {
                int z = 0;
                while (z < this.zChunks) {
                    int x2 = x * 8;
                    int y2 = y * 8;
                    int z2 = z * 8;
                    int x3 = x2 + 8;
                    int y3 = y2 + 8;
                    int z3 = z2 + 8;
                    this.chunks[(x + y * this.xChunks) * this.zChunks + z] = new Chunk(this.level, x2, y2, z2, x3, y3, z3);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int i = 0;
        while (i < this.chunks.length) {
            this.chunks[i].needBuild = true;
            ++i;
        }
        this.appearance.setTexture(0, this.terraintex);
    }

    public void checkBuild() {
        int i = 0;
        while (i < this.chunks.length) {
            if (this.chunks[i].needBuild) {
                this.chunks[i].rebuild();
            }
            ++i;
        }
        this.appearance.setTexture(0, this.terraintex);
    }

    public void markForBuild(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.level.width || y >= this.level.depth || z >= this.level.height) {
            return;
        }
        int cx = x >>> 3;
        int cy = y >>> 3;
        int cz = z >>> 3;
        this.chunks[(cx + cy * this.xChunks) * this.zChunks + cz].needBuild = true;
    }

    public void markChunksForBuild(int x0, int y0, int z0, int x1, int y1, int z1) {
        int ix = x0;
        while (ix <= x1) {
            int iy = y0;
            while (iy <= y1) {
                int iz = z0;
                while (iz <= z1) {
                    this.markForBuild(ix, iy, iz);
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
    }

    public void tileChanged(int x, int y, int z) {
        this.markChunksForBuild(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    public void render(Graphics3D gfx3D, Transform tform) {
        int i = 0;
        while (i < this.chunks.length) {
            Chunk chk = this.chunks[i];
            if (!chk.empty) {
                gfx3D.render(chk.vb, chk.ib, this.appearance, tform);
            }
            ++i;
        }
    }
}

