/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.renderer;

import java.util.Vector;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.renderer.TileFace;

public class Chunk {
    public Level level;
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;
    public VertexBuffer vb;
    public IndexBuffer ib;
    public boolean needBuild = true;
    public boolean empty;
    public static int updates = 0;

    public Chunk(Level lvl, int x0, int y0, int z0, int x1, int y1, int z1) {
        this.level = lvl;
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
    }

    public Vector getTileFaces() {
        Vector<TileFace> faces = new Vector<TileFace>();
        int ix = this.x0;
        while (ix < this.x1) {
            int iy = this.y0;
            while (iy < this.y1) {
                int iz = this.z0;
                while (iz < this.z1) {
                    int id = this.level.getTile(ix, iy, iz);
                    if (id != 0) {
                        Tile tle = Tile.tiles[id];
                        int f = 0;
                        while (f < 6) {
                            if (tle.isFaceVisible(this.level, ix, iy, iz, f)) {
                                faces.addElement(tle.getFace(this.level, ix, iy, iz, f));
                            }
                            ++f;
                        }
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return faces;
    }

    public void rebuild() {
        ++updates;
        Vector faces = this.getTileFaces();
        if (faces.size() != 0) {
            this.rebuild(faces);
        } else {
            this.empty = true;
        }
        this.needBuild = false;
    }

    public void rebuild(Vector faces) {
        this.empty = false;
        short[] vertz = new short[faces.size() * 12];
        short[] tex = new short[faces.size() * 8];
        byte[] color = new byte[faces.size() * 12];
        int fc = 0;
        while (fc < faces.size()) {
            TileFace face = (TileFace)faces.elementAt(fc);
            int i = 0;
            while (i < 12) {
                vertz[fc * 12 + i] = face.vert[i];
                ++i;
            }
            i = 0;
            while (i < 8) {
                tex[fc * 8 + i] = face.tex[i];
                ++i;
            }
            i = 0;
            while (i < 12) {
                color[fc * 12 + i] = face.color[i];
                ++i;
            }
            ++fc;
        }
        VertexArray vertArray = new VertexArray(vertz.length / 3, 3, 2);
        vertArray.set(0, vertz.length / 3, vertz);
        VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
        texArray.set(0, tex.length / 2, tex);
        VertexArray colorArray = new VertexArray(color.length / 3, 3, 1);
        colorArray.set(0, color.length / 3, color);
        int[] stripLen = new int[faces.size()];
        int i = 0;
        while (i < stripLen.length) {
            stripLen[i] = 4;
            ++i;
        }
        this.vb = new VertexBuffer();
        this.vb.setPositions(vertArray, 1.0f, null);
        this.vb.setTexCoords(0, texArray, 0.0625f, null);
        this.vb.setColors(colorArray);
        this.ib = new TriangleStripArray(0, stripLen);
        this.needBuild = false;
    }
}

