/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.level.tile;

import java.util.Random;
import net.enderkitty.mobilecraft.HitResult;
import net.enderkitty.mobilecraft.Vec3;
import net.enderkitty.mobilecraft.item.Item;
import net.enderkitty.mobilecraft.item.TileItem;
import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.tile.BookshelfTile;
import net.enderkitty.mobilecraft.level.tile.CalmLiquidTile;
import net.enderkitty.mobilecraft.level.tile.ClothTile;
import net.enderkitty.mobilecraft.level.tile.DirtTile;
import net.enderkitty.mobilecraft.level.tile.GrassTile;
import net.enderkitty.mobilecraft.level.tile.LeafTile;
import net.enderkitty.mobilecraft.level.tile.LiquidTile;
import net.enderkitty.mobilecraft.level.tile.MetalTile;
import net.enderkitty.mobilecraft.level.tile.ObsidianTile;
import net.enderkitty.mobilecraft.level.tile.OreTile;
import net.enderkitty.mobilecraft.level.tile.SandTile;
import net.enderkitty.mobilecraft.level.tile.StoneTile;
import net.enderkitty.mobilecraft.level.tile.TntTile;
import net.enderkitty.mobilecraft.level.tile.TreeTile;
import net.enderkitty.mobilecraft.phys.AABB;
import net.enderkitty.mobilecraft.renderer.TileFace;

public class Tile {
    public static final Tile[] tiles = new Tile[256];
    public static final boolean[] shouldTick = new boolean[256];
    public static final Tile rock = new StoneTile(1, 1);
    public static final Tile grass = new GrassTile(2);
    public static final Tile dirt = new DirtTile(3, 2);
    public static final Tile stoneBrick = new Tile(4, 16);
    public static final Tile wood = new Tile(5, 4);
    public static final Tile placeholder_6 = new Tile(6);
    public static final Tile unbreakable = new Tile(7, 17);
    public static final Tile water = new LiquidTile(8, 1);
    public static final Tile calmWater = new CalmLiquidTile(9, 1);
    public static final Tile lava = new LiquidTile(10, 2);
    public static final Tile calmLava = new CalmLiquidTile(11, 2);
    public static final Tile sand = new SandTile(12, 18);
    public static final Tile gravel = new SandTile(13, 19);
    public static final Tile goldOre = new OreTile(14, 32);
    public static final Tile ironOre = new OreTile(15, 33);
    public static final Tile coalOre = new OreTile(16, 34);
    public static final Tile treeTrunk = new TreeTile(17);
    public static final Tile leaves = new LeafTile(18, 22);
    public static final Tile cloth = new ClothTile(35, 64);
    public static final Tile goldBlock = new MetalTile(41, 40);
    public static final Tile ironBlock = new MetalTile(42, 39);
    public static final Tile redBrick = new Tile(45, 7);
    public static final Tile tnt = new TntTile(46, 8);
    public static final Tile bookshelf = new BookshelfTile(47, 35);
    public static final Tile mossStone = new Tile(48, 36);
    public static final Tile obsidian = new ObsidianTile(49, 37);
    public static final Tile emeraldOre = new OreTile(56, 50);
    public static final Tile emeraldBlock = new MetalTile(57, 104);
    public int tex;
    public final int id;
    public float xx0;
    public float yy0;
    public float zz0;
    public float xx1;
    public float yy1;
    public float zz1;

    static {
        int i = 0;
        while (i < 256) {
            if (tiles[i] != null) {
                Item.items[i] = new TileItem(i - 256);
            }
            ++i;
        }
    }

    public Tile(int id) {
        Tile.tiles[id] = this;
        this.id = id;
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public Tile(int id, int tex) {
        this(id);
        this.tex = tex;
    }

    protected void setTicking(boolean tick) {
        Tile.shouldTick[this.id] = tick;
    }

    protected void setShape(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.xx0 = x0;
        this.yy0 = y0;
        this.zz0 = z0;
        this.xx1 = x1;
        this.yy1 = y1;
        this.zz1 = z1;
    }

    public boolean shouldRenderFace(Level level, int x, int y, int z, int face) {
        return !level.isSolidTile(x, y, z);
    }

    public boolean isFaceVisible(Level level, int x, int y, int z, int face) {
        if (face == 0) {
            return this.shouldRenderFace(level, x, y - 1, z, 0);
        }
        if (face == 1) {
            return this.shouldRenderFace(level, x, y + 1, z, 1);
        }
        if (face == 2) {
            return this.shouldRenderFace(level, x, y, z - 1, 2);
        }
        if (face == 3) {
            return this.shouldRenderFace(level, x, y, z + 1, 3);
        }
        if (face == 4) {
            return this.shouldRenderFace(level, x - 1, y, z, 4);
        }
        if (face == 5) {
            return this.shouldRenderFace(level, x + 1, y, z, 5);
        }
        return false;
    }

    public short[] getFaceVerts(int x, int y, int z, int face) {
        short x0 = (short)x;
        short y0 = (short)y;
        short z0 = (short)z;
        short x1 = (short)(x + 1);
        short y1 = (short)(y + 1);
        short z1 = (short)(z + 1);
        if (face == 0) {
            return new short[]{x1, y0, z1, x0, y0, z1, x1, y0, z0, x0, y0, z0};
        }
        if (face == 1) {
            return new short[]{x1, y1, z0, x0, y1, z0, x1, y1, z1, x0, y1, z1};
        }
        if (face == 2) {
            return new short[]{x0, y1, z0, x1, y1, z0, x0, y0, z0, x1, y0, z0};
        }
        if (face == 3) {
            return new short[]{x1, y1, z1, x0, y1, z1, x1, y0, z1, x0, y0, z1};
        }
        if (face == 4) {
            return new short[]{x0, y1, z1, x0, y1, z0, x0, y0, z1, x0, y0, z0};
        }
        if (face == 5) {
            return new short[]{x1, y1, z0, x1, y1, z1, x1, y0, z0, x1, y0, z1};
        }
        return null;
    }

    public short[] getFaceTex(Level lvl, int x, int y, int z, int f) {
        int ftex = this.getTexture(lvl, x, y, z, f);
        int tx = ftex & 0xF;
        int ty = ftex >>> 4;
        short u0 = (short)tx;
        short v0 = (short)ty;
        short u1 = (short)(tx + 1);
        short v1 = (short)(ty + 1);
        return new short[]{u1, v0, u0, v0, u1, v1, u0, v1};
    }

    public short[] getFaceTex(int f) {
        int tx = this.getTexture(f) & 0xF;
        int ty = this.getTexture(f) >>> 4;
        short u0 = (short)tx;
        short v0 = (short)ty;
        short u1 = (short)(tx + 1);
        short v1 = (short)(ty + 1);
        return new short[]{u1, v0, u0, v0, u1, v1, u0, v1};
    }

    public byte[] getFaceColor(int f) {
        int shade = 255;
        int f2 = f & 6;
        if (f == 0) {
            shade = 127;
        }
        if (f2 == 2) {
            shade = 204;
        }
        if (f2 == 4) {
            shade = 153;
        }
        byte[] clrs = new byte[12];
        int i = 0;
        while (i < 12) {
            clrs[i] = (byte)shade;
            ++i;
        }
        return clrs;
    }

    public TileFace getFaceNoLevel(int x, int y, int z, int f) {
        return new TileFace(this.getFaceVerts(x, y, z, f), this.getFaceTex(f), this.getFaceColor(f));
    }

    public TileFace getFace(Level lvl, int x, int y, int z, int f) {
        return new TileFace(this.getFaceVerts(x, y, z, f), this.getFaceTex(lvl, x, y, z, f), this.getFaceColor(f));
    }

    public int getTexture(Level lvl, int x, int y, int z, int f) {
        return this.getTexture(f, lvl.getData(x, y, z));
    }

    public int getTexture(int f, int dv) {
        return this.getTexture(f);
    }

    public int getTexture(int face) {
        return this.tex;
    }

    public AABB getTileAABB(int x, int y, int z) {
        return new AABB(x, y, z, x + 1, y + 1, z + 1);
    }

    public AABB getAABB(int x, int y, int z) {
        return new AABB(x, y, z, x + 1, y + 1, z + 1);
    }

    public boolean isSolid() {
        return true;
    }

    public boolean mayPick() {
        return true;
    }

    public void tick(Level lvl, int x, int y, int z, Random random) {
    }

    public void destroy(Level lvl, int x, int y, int z) {
    }

    public void neighborChanged(Level lvl, int x, int y, int z, int type) {
    }

    public void onPlace(Level lvl, int x, int y, int z) {
    }

    public void onRemove(Level lvl, int x, int y, int z) {
    }

    public int getResourceCount(Random random) {
        return 1;
    }

    public int getLiquidType() {
        return 0;
    }

    public HitResult clip(Level level, int integer2, int integer3, int integer4, Vec3 vec35, Vec3 vec36) {
        vec35 = vec35.add(-integer2, -integer3, -integer4);
        vec36 = vec36.add(-integer2, -integer3, -integer4);
        Vec3 clipX = vec35.clipX(vec36, this.xx0);
        Vec3 clipX2 = vec35.clipX(vec36, this.xx1);
        Vec3 clipY = vec35.clipY(vec36, this.yy0);
        Vec3 clipY2 = vec35.clipY(vec36, this.yy1);
        Vec3 clipZ = vec35.clipZ(vec36, this.zz0);
        Vec3 clipZ2 = vec35.clipZ(vec36, this.zz1);
        if (!this.containsX(clipX)) {
            clipX = null;
        }
        if (!this.containsX(clipX2)) {
            clipX2 = null;
        }
        if (!this.containsY(clipY)) {
            clipY = null;
        }
        if (!this.containsY(clipY2)) {
            clipY2 = null;
        }
        if (!this.containsZ(clipZ)) {
            clipZ = null;
        }
        if (!this.containsZ(clipZ2)) {
            clipZ2 = null;
        }
        Vec3 vec37 = null;
        if (clipX != null && (vec37 == null || vec35.distanceTo(clipX) < vec35.distanceTo(vec37))) {
            vec37 = clipX;
        }
        if (clipX2 != null && (vec37 == null || vec35.distanceTo(clipX2) < vec35.distanceTo(vec37))) {
            vec37 = clipX2;
        }
        if (clipY != null && (vec37 == null || vec35.distanceTo(clipY) < vec35.distanceTo(vec37))) {
            vec37 = clipY;
        }
        if (clipY2 != null && (vec37 == null || vec35.distanceTo(clipY2) < vec35.distanceTo(vec37))) {
            vec37 = clipY2;
        }
        if (clipZ != null && (vec37 == null || vec35.distanceTo(clipZ) < vec35.distanceTo(vec37))) {
            vec37 = clipZ;
        }
        if (clipZ2 != null && (vec37 == null || vec35.distanceTo(clipZ2) < vec35.distanceTo(vec37))) {
            vec37 = clipZ2;
        }
        if (vec37 == null) {
            return null;
        }
        int integer5 = -1;
        if (vec37 == clipX) {
            integer5 = 4;
        }
        if (vec37 == clipX2) {
            integer5 = 5;
        }
        if (vec37 == clipY) {
            integer5 = 0;
        }
        if (vec37 == clipY2) {
            integer5 = 1;
        }
        if (vec37 == clipZ) {
            integer5 = 2;
        }
        if (vec37 == clipZ2) {
            integer5 = 3;
        }
        return new HitResult(integer2, integer3, integer4, integer5, vec37.add(integer2, integer3, integer4));
    }

    private boolean containsX(Vec3 vec3) {
        return vec3 != null && vec3.y >= this.yy0 && vec3.y <= this.yy1 && vec3.z >= this.zz0 && vec3.z <= this.zz1;
    }

    private boolean containsY(Vec3 vec3) {
        return vec3 != null && vec3.x >= this.xx0 && vec3.x <= this.xx1 && vec3.z >= this.zz0 && vec3.z <= this.zz1;
    }

    private boolean containsZ(Vec3 vec3) {
        return vec3 != null && vec3.x >= this.xx0 && vec3.x <= this.xx1 && vec3.y >= this.yy0 && vec3.y <= this.yy1;
    }

    public void wasExploded(Level level, int x, int y, int z) {
    }
}

