/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.level.tile;

import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.phys.AABB;

public class LiquidTile
extends Tile {
    public int liquidType;
    public int calmTileId;
    public int tileId;

    public LiquidTile(int id, int liquidType) {
        super(id);
        this.liquidType = liquidType;
        this.tex = 14;
        if (liquidType == 2) {
            this.tex = 30;
        }
        this.tileId = id;
        this.calmTileId = id + 1;
        this.setTicking(true);
    }

    public boolean shouldRenderFace(Level level, int x, int y, int z, int face) {
        int id = level.getTile(x, y, z);
        return id != this.tileId && id != this.calmTileId && super.shouldRenderFace(level, x, y, z, face);
    }

    public boolean mayPick() {
        return false;
    }

    public AABB getAABB(int x, int y, int z) {
        return null;
    }

    public boolean isSolid() {
        return false;
    }

    public int getLiquidType() {
        return this.liquidType;
    }
}

