/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.level;

import java.util.Random;
import java.util.Vector;
import net.enderkitty.mobilecraft.HitResult;
import net.enderkitty.mobilecraft.Vec3;
import net.enderkitty.mobilecraft.entity.Entity;
import net.enderkitty.mobilecraft.level.LevelListener;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.phys.AABB;
import util.Mth;

public class Level {
    public int width;
    public int height;
    public int depth;
    public byte[] blocks;
    public byte[] dataArray;
    public Vector levelListeners = new Vector();
    public Random random = new Random();
    public Vector entities;
    public boolean creativeMode;

    public void initTransient() {
        if (this.entities == null) {
            this.entities = new Vector();
        }
    }

    public void setData(int w, int d, int h, byte[] blcks, byte[] arr2) {
        this.width = w;
        this.height = h;
        this.depth = d;
        this.blocks = blcks;
        this.dataArray = arr2 == null ? new byte[blcks.length] : arr2;
        int i = 0;
        while (i < this.levelListeners.size()) {
            ((LevelListener)this.levelListeners.elementAt(i)).allChanged();
            ++i;
        }
        this.initTransient();
    }

    public void setData(int w, int d, int h, byte[] blcks) {
        this.setData(w, d, h, blcks, null);
    }

    public void addListener(LevelListener listener) {
        this.levelListeners.addElement(listener);
    }

    public Vector getCubes(AABB box) {
        Vector<AABB> boxes = new Vector<AABB>();
        int x0 = (int)Math.floor(box.x0);
        int x2 = (int)Math.floor(box.x1 + 1.0f);
        int y0 = (int)Math.floor(box.y0);
        int y2 = (int)Math.floor(box.y1 + 1.0f);
        int z0 = (int)Math.floor(box.z0);
        int z2 = (int)Math.floor(box.z1 + 1.0f);
        int x3 = x0;
        while (x3 < x2) {
            int y3 = y0;
            while (y3 < y2) {
                int z3 = z0;
                while (z3 < z2) {
                    AABB aabb;
                    Tile tile;
                    if (x3 >= 0 && y3 >= 0 && z3 >= 0 && x3 < this.width && y3 < this.depth && z3 < this.height && (tile = Tile.tiles[this.getTile(x3, y3, z3)]) != null && (aabb = tile.getAABB(x3, y3, z3)) != null) {
                        boxes.addElement(aabb);
                    }
                    ++z3;
                }
                ++y3;
            }
            ++x3;
        }
        return boxes;
    }

    public boolean setTile(int x, int y, int z, int type) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.depth || z >= this.height) {
            return false;
        }
        if (type == this.blocks[(y * this.height + z) * this.width + x]) {
            return false;
        }
        int oldTile = this.getTile(x, y, z);
        this.blocks[(y * this.height + z) * this.width + x] = (byte)type;
        this.setData(x, y, z, 0);
        if (oldTile != 0) {
            Tile.tiles[oldTile].onRemove(this, x, y, z);
        }
        if (type != 0) {
            Tile.tiles[type].onPlace(this, x, y, z);
        }
        int i = 0;
        while (i < this.levelListeners.size()) {
            ((LevelListener)this.levelListeners.elementAt(i)).tileChanged(x, y, z);
            ++i;
        }
        return true;
    }

    public boolean setTileNoUpdate(int x, int y, int z, int type) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.depth || z >= this.height) {
            return false;
        }
        if (type == this.blocks[(y * this.height + z) * this.width + x]) {
            return false;
        }
        this.blocks[(y * this.height + z) * this.width + x] = (byte)type;
        return true;
    }

    public int getTile(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.depth || z >= this.height) {
            return 0;
        }
        return this.blocks[(y * this.height + z) * this.width + x];
    }

    public boolean isSolidTile(int x, int y, int z) {
        Tile tile = Tile.tiles[this.getTile(x, y, z)];
        return tile != null && tile.isSolid();
    }

    public void tickEntities() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity e = (Entity)this.entities.elementAt(i);
            e.tick();
            if (e.removed) {
                this.entities.removeElementAt(i--);
            }
            ++i;
        }
    }

    public void tick() {
    }

    public boolean containsAnyLiquid(AABB box) {
        int x0 = (int)Math.floor(box.x0);
        int x2 = (int)Math.floor(box.x1 + 1.0f);
        int y0 = (int)Math.floor(box.y0);
        int y2 = (int)Math.floor(box.y1 + 1.0f);
        int z0 = (int)Math.floor(box.z0);
        int z2 = (int)Math.floor(box.z1 + 1.0f);
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (z0 < 0) {
            z0 = 0;
        }
        if (x2 > this.width) {
            x2 = this.width;
        }
        if (y2 > this.depth) {
            y2 = this.depth;
        }
        if (z2 > this.height) {
            z2 = this.height;
        }
        int x3 = x0;
        while (x3 < x2) {
            int y3 = y0;
            while (y3 < y2) {
                int z3 = z0;
                while (z3 < z2) {
                    Tile tile = Tile.tiles[this.getTile(x3, y3, z3)];
                    if (tile != null && tile.getLiquidType() > 0) {
                        return true;
                    }
                    ++z3;
                }
                ++y3;
            }
            ++x3;
        }
        return false;
    }

    public final boolean containsFireTile(AABB aABB) {
        int integer3 = (int)aABB.x0;
        int integer4 = (int)aABB.x1 + 1;
        int integer5 = (int)aABB.y0;
        int integer6 = (int)aABB.y1 + 1;
        int integer7 = (int)aABB.z0;
        int integer2 = (int)aABB.z1 + 1;
        while (integer3 < integer4) {
            int j = integer5;
            while (j < integer6) {
                int k = integer7;
                while (k < integer2) {
                    int id = this.getTile(integer3, j, k);
                    if (id == Tile.lava.id || id == Tile.calmLava.id) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++integer3;
        }
        return false;
    }

    public boolean containsLiquid(AABB box, int liquidId) {
        int x0 = (int)Math.floor(box.x0);
        int x2 = (int)Math.floor(box.x1 + 1.0f);
        int y0 = (int)Math.floor(box.y0);
        int y2 = (int)Math.floor(box.y1 + 1.0f);
        int z0 = (int)Math.floor(box.z0);
        int z2 = (int)Math.floor(box.z1 + 1.0f);
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (z0 < 0) {
            z0 = 0;
        }
        if (x2 > this.width) {
            x2 = this.width;
        }
        if (y2 > this.depth) {
            y2 = this.depth;
        }
        if (z2 > this.height) {
            z2 = this.height;
        }
        int x3 = x0;
        while (x3 < x2) {
            int y3 = y0;
            while (y3 < y2) {
                int z3 = z0;
                while (z3 < z2) {
                    Tile tile = Tile.tiles[this.getTile(x3, y3, z3)];
                    if (tile != null && tile.getLiquidType() == liquidId) {
                        return true;
                    }
                    ++z3;
                }
                ++y3;
            }
            ++x3;
        }
        return false;
    }

    public int getData(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.depth || z >= this.height) {
            return 0;
        }
        return this.dataArray[(y * this.height + z) * this.width + x] >>> 4 & 0xF;
    }

    public void setData(int x, int y, int z, int dv) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.depth || z >= this.height) {
            return;
        }
        this.dataArray[(y * this.height + z) * this.width + x] = (byte)((this.dataArray[(y * this.height + z) * this.width + x] & 0xF) + (dv << 4));
        int i = 0;
        while (i < this.levelListeners.size()) {
            ((LevelListener)this.levelListeners.elementAt(i)).tileChanged(x, y, z);
            ++i;
        }
    }

    public final HitResult clip(Vec3 a1, Vec3 a2) {
        if (Float.isNaN(a1.x) || Float.isNaN(a1.y) || Float.isNaN(a1.z)) {
            return null;
        }
        if (Float.isNaN(a2.x) || Float.isNaN(a2.y) || Float.isNaN(a2.z)) {
            return null;
        }
        int floor = Mth.floor(a2.x);
        int floor2 = Mth.floor(a2.y);
        int floor3 = Mth.floor(a2.z);
        int floor4 = Mth.floor(a1.x);
        int floor5 = Mth.floor(a1.y);
        int floor6 = Mth.floor(a1.z);
        int n = 20;
        while (n-- >= 0) {
            HitResult clip;
            float z2;
            float y2;
            float x2;
            Vec3 vec4;
            int n8;
            if (Float.isNaN(a1.x) || Float.isNaN(a1.y) || Float.isNaN(a1.z)) {
                return null;
            }
            if (floor4 == floor && floor5 == floor2 && floor6 == floor3) {
                return null;
            }
            float x = 999.0f;
            float y = 999.0f;
            float z = 999.0f;
            if (floor > floor4) {
                x = (float)floor4 + 1.0f;
            }
            if (floor < floor4) {
                x = floor4;
            }
            if (floor2 > floor5) {
                y = (float)floor5 + 1.0f;
            }
            if (floor2 < floor5) {
                y = floor5;
            }
            if (floor3 > floor6) {
                z = (float)floor6 + 1.0f;
            }
            if (floor3 < floor6) {
                z = floor6;
            }
            float n2 = 999.0f;
            float n3 = 999.0f;
            float n4 = 999.0f;
            float n5 = a2.x - a1.x;
            float n6 = a2.y - a1.y;
            float n7 = a2.z - a1.z;
            if (x != 999.0f) {
                n2 = (x - a1.x) / n5;
            }
            if (y != 999.0f) {
                n3 = (y - a1.y) / n6;
            }
            if (z != 999.0f) {
                n4 = (z - a1.z) / n7;
            }
            if (n2 < n3 && n2 < n4) {
                n8 = floor > floor4 ? 4 : 5;
                a1.x = x;
                a1.y += n6 * n2;
                a1.z += n7 * n2;
            } else if (n3 < n4) {
                n8 = floor2 > floor5 ? 0 : 1;
                a1.x += n5 * n3;
                a1.y = y;
                a1.z += n7 * n3;
            } else {
                n8 = floor3 > floor6 ? 2 : 3;
                a1.x += n5 * n4;
                a1.y += n6 * n4;
                a1.z = z;
            }
            Vec3 vec3 = vec4 = new Vec3(a1.x, a1.y, a1.z);
            vec3.x = x2 = (float)Mth.floor(a1.x);
            floor4 = (int)x2;
            if (n8 == 5) {
                --floor4;
                Vec3 vec5 = vec4;
                vec5.x += 1.0f;
            }
            Vec3 vec6 = vec4;
            vec6.y = y2 = (float)Mth.floor(a1.y);
            floor5 = (int)y2;
            if (n8 == 1) {
                --floor5;
                Vec3 vec7 = vec4;
                vec7.y += 1.0f;
            }
            Vec3 vec8 = vec4;
            vec8.z = z2 = (float)Mth.floor(a1.z);
            floor6 = (int)z2;
            if (n8 == 3) {
                --floor6;
                Vec3 vec9 = vec4;
                vec9.z += 1.0f;
            }
            int tile = this.getTile(floor4, floor5, floor6);
            Tile tile2 = Tile.tiles[tile];
            if (tile <= 0 || !tile2.mayPick() || (clip = tile2.clip(this, floor4, floor5, floor6, a1, a2)) == null) continue;
            return clip;
        }
        return null;
    }

    public void addEntity(Entity e) {
        this.entities.addElement(e);
    }

    public void explode(Entity entity, float x, float y, float z, float r) {
        int n = (int)(x - r - 1.0f);
        int n2 = (int)(x + r + 1.0f);
        int n3 = (int)(y - r - 1.0f);
        int n4 = (int)(y + r + 1.0f);
        int n5 = (int)(z - r - 1.0f);
        int n6 = (int)(z + r + 1.0f);
        int i = n;
        while (i < n2) {
            int j = n4 - 1;
            while (j >= n3) {
                int k = n5;
                while (k < n6) {
                    int tile;
                    float n7 = (float)i + 0.5f - x;
                    float n8 = (float)j + 0.5f - y;
                    float n9 = (float)k + 0.5f - z;
                    if (i >= 0 && j >= 0 && k >= 0 && i < this.width && j < this.depth && k < this.height && n7 * n7 + n8 * n8 + n9 * n9 < r * r && (tile = this.getTile(i, j, k)) > 0) {
                        this.setTile(i, j, k, 0);
                        Tile.tiles[tile].wasExploded(this, i, j, k);
                    }
                    ++k;
                }
                --j;
            }
            ++i;
        }
    }

    public void playSound(Entity e, String s, float f1, float f2) {
    }

    public void playSound(float x, float y, float z, String s, float f1, float f2) {
    }
}

