/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.gui;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.enderkitty.mobilecraft.Minecraft;
import net.enderkitty.mobilecraft.entity.player.Inventory;
import net.enderkitty.mobilecraft.gui.Font;
import net.enderkitty.mobilecraft.item.Item;
import net.enderkitty.mobilecraft.item.ItemInstance;
import net.enderkitty.mobilecraft.renderer.Textures;

public class Gui {
    public Image icons;
    public Image guitex;
    public Image itemtex;
    public Image terrain;
    public Random random = new Random();
    public Minecraft minecraft;
    public Graphics gfx;
    public Font font;
    public int tickCount = 0;

    public Gui(Minecraft mc) {
        this.minecraft = mc;
        this.gfx = mc.gfx;
        this.font = new Font("/default.png");
        this.loadTex();
    }

    public void loadTex() {
        this.icons = Textures.tex[0];
        this.guitex = Textures.tex[1];
        this.itemtex = Textures.tex[3];
        this.terrain = Textures.tex[2];
    }

    public void render(float a) {
        boolean b;
        int height = this.minecraft.height;
        Inventory inv = this.minecraft.player.inventory;
        this.gfx.drawRegion(this.guitex, 0, 0, 40, 22, 0, 69, height - 22, 0);
        this.gfx.drawRegion(this.guitex, 140, 0, 42, 22, 0, 109, height - 22, 0);
        this.gfx.drawRegion(this.guitex, 0, 22, 24, 22, 0, 68 + inv.selected * 20, height - 23, 0);
        boolean bl = b = this.minecraft.player.invulnerableTime / 3 % 2 == 1;
        if (this.minecraft.player.invulnerableTime < 10) {
            b = false;
        }
        int health = this.minecraft.player.health;
        int lastHealth = this.minecraft.player.lastHealth;
        this.random.setSeed(this.tickCount * 312871);
        if (this.minecraft.gameMode.canHurtPlayer()) {
            int hx = 69;
            int i = 0;
            while (i < 9) {
                int hy = height - 32;
                int n = 0;
                if (b) {
                    n = 1;
                }
                if (health <= 4) {
                    hy += this.random.nextInt(2);
                }
                this.gfx.drawRegion(this.icons, 16 + n * 9, 0, 9, 9, 0, hx + i * 8, hy, 0);
                if (b) {
                    if (i * 2 + 1 < lastHealth) {
                        this.gfx.drawRegion(this.icons, 70, 0, 8, 8, 0, hx + i * 8, hy, 0);
                    }
                    if (i * 2 + 1 == lastHealth) {
                        this.gfx.drawRegion(this.icons, 79, 0, 8, 8, 0, hx + i * 8, hy, 0);
                    }
                }
                if (i * 2 + 1 < health) {
                    this.gfx.drawRegion(this.icons, 52, 0, 8, 8, 0, hx + i * 8, hy, 0);
                }
                if (i * 2 + 1 == health) {
                    this.gfx.drawRegion(this.icons, 61, 0, 8, 8, 0, hx + i * 8, hy, 0);
                }
                ++i;
            }
            if (this.minecraft.player.isUnderWater()) {
                int hy = height - 32;
                int airSupply = this.minecraft.player.airSupply * 9 / 10;
                int j = (int)Math.ceil((double)(airSupply - 2) * 9.0 / 270.0);
                int integer5 = (int)Math.ceil((double)airSupply * 9.0 / 270.0) - j;
                int k = 0;
                while (k < j + integer5) {
                    if (k < j) {
                        this.gfx.drawRegion(this.icons, 16, 18, 9, 9, 0, hx + k * 8, hy - 9, 0);
                    } else {
                        this.gfx.drawRegion(this.icons, 25, 18, 9, 9, 0, hx + k * 8, hy - 9, 0);
                    }
                    ++k;
                }
            }
        }
        int i = 0;
        while (i < 4) {
            ItemInstance item = this.minecraft.player.inventory.items[i];
            if (item != null) {
                int icon = Item.items[item.id].getIcon();
                int tx = (icon & 0xF) << 4;
                int ty = icon & 0xF0;
                Image icontex = null;
                icontex = item.id < 256 ? this.terrain : this.itemtex;
                this.gfx.drawRegion(icontex, tx, ty, 16, 16, 0, 72 + i * 20, height - 19, 0);
                if (item.count > 1) {
                    String amount = "" + item.count;
                    this.font.drawShadow(this.gfx, amount, 89 + i * 20 - this.font.width(amount), height - 10, 0xFFFFFF);
                }
            }
            ++i;
        }
    }

    public void tick() {
        ++this.tickCount;
    }
}

