/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.gui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Font {
    private int[] charWidths = new int[256];
    public Image fonttex;

    public Font(String name) {
        this.loadTex(name);
        Image img = this.fonttex;
        int w = img.getWidth();
        int h = img.getHeight();
        int[] rawPixels = new int[w * h];
        img.getRGB(rawPixels, 0, w, 0, 0, w, h);
        int i = 0;
        while (i < 128) {
            int xt = i % 16;
            int yt = i / 16;
            int x = 0;
            boolean emptyColumn = false;
            while (x < 8 && !emptyColumn) {
                int xPixel = xt * 8 + x;
                emptyColumn = true;
                int y = 0;
                while (y < 8 && emptyColumn) {
                    int yPixel = (yt * 8 + y) * w;
                    int pixel = rawPixels[xPixel + yPixel] & 0xFF;
                    if (pixel > 128) {
                        emptyColumn = false;
                    }
                    ++y;
                }
                ++x;
            }
            if (i == 32) {
                x = 4;
            }
            this.charWidths[i] = x;
            ++i;
        }
    }

    public void loadTex(String name) {
        try {
            this.fonttex = Image.createImage((String)name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawShadow(Graphics gfx, String str, int x, int y, int color) {
        this.draw(gfx, str, x + 1, y + 1, color, true);
        this.draw(gfx, str, x, y, color, false);
    }

    public void draw(Graphics gfx, String str, int x, int y, int color) {
        this.draw(gfx, str, x, y, color, false);
    }

    public void draw(Graphics gfx, String str, int x, int y, int color, boolean darken) {
        char[] chars = str.toCharArray();
        if (darken) {
            color = (color & 0xFCFCFC) >> 2;
        }
        int xo = 0;
        int i = 0;
        while (i < chars.length) {
            char chr = chars[i];
            int tx = (chr & 0xF) << 3;
            int ty = (chr & 0xF0) >> 1;
            int[] rgb = new int[64];
            this.fonttex.getRGB(rgb, 0, 8, tx, ty, 8, 8);
            int j = 0;
            while (j < 64) {
                int mask = rgb[j] & 0xFF000000 | color;
                rgb[j] = rgb[j] & mask;
                ++j;
            }
            gfx.drawRGB(rgb, 0, 8, x + xo, y, 8, 8, true);
            xo += this.charWidths[chr];
            ++i;
        }
    }

    public int width(String str) {
        char[] chars = str.toCharArray();
        int len = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '&') {
                ++i;
            } else {
                len += this.charWidths[chars[i]];
            }
            ++i;
        }
        return len;
    }
}

