/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.gui;

import java.util.Vector;
import javax.microedition.lcdui.Image;
import net.enderkitty.mobilecraft.entity.player.Inventory;
import net.enderkitty.mobilecraft.gui.Screen;
import net.enderkitty.mobilecraft.item.Item;
import net.enderkitty.mobilecraft.item.ItemInstance;
import net.enderkitty.mobilecraft.renderer.Textures;

public class CreativeScreen
extends Screen {
    public Vector items;
    public Image itemtex = Textures.tex[3];
    public Image terrain = Textures.tex[2];
    public int sitm = 0;

    public void init() {
        this.items = new Vector();
        int i = 0;
        while (i < 1024) {
            if (Item.items[i] != null) {
                this.items.addElement(Item.items[i]);
            }
            ++i;
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 251) {
            Inventory inv = this.minecraft.player.inventory;
            Item item = (Item)this.items.elementAt(this.sitm);
            inv.items[inv.selected] = new ItemInstance(item.id, 1);
            this.minecraft.setScreen(null);
        }
        if (keyCode == 249) {
            this.minecraft.setScreen(null);
        }
        int count = this.items.size();
        if (keyCode == this.getKeyCode(1)) {
            this.sitm -= 9;
        }
        if (keyCode == this.getKeyCode(6)) {
            this.sitm += 9;
        }
        if (keyCode == this.getKeyCode(2)) {
            --this.sitm;
        }
        if (keyCode == this.getKeyCode(5)) {
            ++this.sitm;
        }
        if (this.sitm < 0) {
            this.sitm = 0;
        }
        if (this.sitm >= count) {
            this.sitm = count - 1;
        }
    }

    public void render() {
        this.gfx.setColor(0x3F3F3F);
        this.gfx.fillRect(8, 8, this.width - 16, this.height - 32);
        this.gfx.setColor(0xFFFFFF);
        this.gfx.drawString("Select Item", 16, 16, 0);
        this.renderItems();
    }

    public void renderItems() {
        int count = this.items.size();
        int rows = (count - 1) / 9 + 1;
        int iy = 0;
        while (iy < rows) {
            int ix = 0;
            while (ix < 9) {
                int indx = iy * 9 + ix;
                if (indx < count) {
                    Item item = (Item)this.items.elementAt(indx);
                    int icon = item.getIcon();
                    int tx = (icon & 0xF) << 4;
                    int ty = icon & 0xF0;
                    Image icontex = null;
                    icontex = item.id < 256 ? this.terrain : this.itemtex;
                    if (indx == this.sitm) {
                        this.gfx.drawRect(26 + ix * 20, 42 + iy * 20, 19, 19);
                    }
                    this.gfx.drawRegion(icontex, tx, ty, 16, 16, 0, 28 + ix * 20, 44 + iy * 20, 0);
                }
                ++ix;
            }
            ++iy;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

