/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.gui;

import net.enderkitty.mobilecraft.Options;
import net.enderkitty.mobilecraft.gui.Choice;
import net.enderkitty.mobilecraft.gui.Screen;

public class ControlsScreen
extends Screen {
    private Screen lastScreen;
    protected String title = "Controls";
    private Options options;
    private int selectedKey = -1;

    public ControlsScreen(Screen screen, Options options) {
        this.lastScreen = screen;
        this.options = options;
    }

    public void init() {
        int i = 0;
        while (i < this.options.keyMappings.length) {
            this.choices.addElement(new Choice(i, 32, 52 + i * 20, this.options.getKeyMessage(i)));
            ++i;
        }
        this.choices.addElement(new Choice(200, 32, 252, "Done"));
    }

    public void choiceSelected(Choice c) {
        int i = 0;
        while (i < this.options.keyMappings.length) {
            ((Choice)this.choices.elementAt((int)i)).msg = this.options.getKeyMessage(i);
            ++i;
        }
        if (c.id == 200) {
            this.minecraft.setScreen(this.lastScreen);
        } else {
            this.selectedKey = c.id;
            c.msg = "> " + this.options.getKeyMessage(c.id) + " <";
        }
    }

    public void keyPressed(int keyCode) {
        if (this.selectedKey >= 0) {
            this.options.setKey(this.selectedKey, keyCode);
            ((Choice)this.choices.elementAt((int)this.selectedKey)).msg = this.options.getKeyMessage(this.selectedKey);
            this.selectedKey = -1;
        } else {
            super.keyPressed(keyCode);
        }
    }

    public void render() {
        this.gfx.setColor(0x3F3F3F);
        this.gfx.fillRect(16, 16, this.width - 32, this.height - 32);
        this.gfx.setColor(0xFFFFFF);
        this.gfx.drawString(this.title, 32, 22, 0);
        super.render();
    }
}

