/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.entity.mob;

import net.enderkitty.mobilecraft.entity.Entity;
import net.enderkitty.mobilecraft.level.Level;

public class Mob
extends Entity {
    public int invulnerableDuration = 20;
    public float rot;
    public float timeOffs;
    public float speed;
    public float rotA;
    public float yBodyRot = 0.0f;
    public float yBodyRotO = 0.0f;
    public int health = 18;
    public int lastHealth;
    public int hurtTime;
    public int hurtDuration;
    public float hurtDir = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float oTilt;
    public float tilt;
    protected float xxa;
    protected float yya;
    protected float yRotA;
    protected boolean jumping = false;

    public Mob(Level lvl) {
        super(lvl);
    }

    public float getHeadHeight() {
        return this.bbHeight * 0.85f;
    }

    public void tick() {
        super.tick();
        if (this.isUnderWater()) {
            --this.airSupply;
            if (this.airSupply == -20) {
                this.airSupply = 0;
                this.hurt(null, 2);
            }
            this.onFire = 0;
        } else {
            this.airSupply = this.airCapacity;
        }
        this.oTilt = this.tilt;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.remove();
            }
        }
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
        this.aiStep();
    }

    public void heal(int var0) {
        if (this.health <= 0) {
            return;
        }
        this.health += var0;
        if (this.health > 18) {
            this.health = 18;
        }
        this.invulnerableTime = this.invulnerableDuration / 2;
    }

    public boolean hurt(Entity e, int var0) {
        if (this.health <= 0) {
            return false;
        }
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f) {
            if (this.lastHealth - var0 >= this.health) {
                return false;
            }
            this.health = this.lastHealth - var0;
        } else {
            this.lastHealth = this.health;
            this.invulnerableTime = this.invulnerableDuration;
            this.health -= var0;
            int n = 10;
            this.hurtDuration = 10;
            this.hurtTime = 10;
        }
        if (this.health <= 0) {
            this.die(e);
        }
        return true;
    }

    public void die(Entity e) {
    }

    public void causeFallDamage(float dist) {
        int dmg = (int)Math.ceil(dist - 3.0f);
        if (dmg > 0) {
            this.hurt(null, dmg);
        }
    }

    public void travel(float xa, float ya) {
        if (this.isInWater()) {
            float yo = this.y;
            this.moveRelative(xa, ya, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.8f;
            this.yd *= 0.8f;
            this.zd *= 0.8f;
            this.yd -= 0.02f;
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + 0.6f - this.y + yo, this.zd)) {
                this.yd = 0.3f;
            }
        } else if (this.isInLava()) {
            float yo = this.y;
            this.moveRelative(xa, ya, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.5f;
            this.yd *= 0.5f;
            this.zd *= 0.5f;
            this.yd -= 0.02f;
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + 0.6f - this.y + yo, this.zd)) {
                this.yd = 0.3f;
            }
        } else {
            this.moveRelative(xa, ya, this.onGround ? 0.1f : 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.91f;
            this.yd *= 0.98f;
            this.zd *= 0.91f;
            this.yd -= 0.08f;
            if (this.onGround) {
                this.xd *= 0.6f;
                this.zd *= 0.6f;
            }
        }
    }

    public void aiStep() {
        if (this.health <= 0) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.yya = 0.0f;
            this.yRotA = 0.0f;
        } else {
            this.updateAi();
        }
        boolean inWater = this.isInWater();
        boolean inLava = this.isInLava();
        if (this.jumping) {
            if (inWater) {
                this.yd += 0.04f;
            } else if (inLava) {
                this.yd += 0.04f;
            } else if (this.onGround) {
                this.yd = 0.42f;
            }
        }
        this.xxa *= 0.98f;
        this.yya *= 0.98f;
        this.yRotA *= 0.9f;
        this.travel(this.xxa, this.yya);
    }

    public void updateAi() {
    }

    public void outOfWorld() {
        this.hurt(null, 4);
    }
}

