/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft.entity;

import java.util.Vector;
import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.phys.AABB;
import util.Mth;

public class Entity {
    public Level level;
    public float xo;
    public float yo;
    public float zo;
    public float x;
    public float y;
    public float z;
    public float xd;
    public float yd;
    public float zd;
    public float yRot;
    public float xRot;
    public float yRotO;
    public float xRotO;
    public AABB bb;
    public boolean onGround = false;
    public boolean horizontalCollision = false;
    public boolean removed = false;
    public float heightOffset = 0.0f;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    public float walkDistO = 0.0f;
    public float walkDist = 0.0f;
    public float fallDistance = 0.0f;
    public int flameTime = 1;
    public int onFire = 0;
    public int airCapacity = 300;
    public int invulnerableTime = 0;
    public int airSupply = 300;

    public Entity(Level l) {
        this.level = l;
    }

    public void remove() {
        this.removed = true;
    }

    public void setSize(float w, float h) {
        this.bbWidth = w;
        this.bbHeight = h;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        float w = this.bbWidth / 2.0f;
        float h = this.bbHeight / 2.0f;
        this.bb = new AABB(x - w, y - h, z - w, x + w, y + h, z + w);
    }

    public void turn(float xo, float yo) {
        this.yRot += (float)((double)xo * 0.15);
        this.xRot -= (float)((double)yo * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
    }

    public void tick() {
        this.walkDistO = this.walkDist;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xRotO = this.xRot;
        this.yRotO = this.yRot;
        if (this.isInWater()) {
            this.fallDistance = 0.0f;
            this.onFire = 0;
        }
        if (this.onFire > 0) {
            if (this.onFire % 20 == 0) {
                this.hurt(null, 1);
            }
            --this.onFire;
        }
        if (this.isInLava()) {
            this.hurt(null, 10);
            this.onFire = 600;
        }
        if ((double)this.y < -64.0) {
            this.outOfWorld();
        }
    }

    public void outOfWorld() {
        this.remove();
    }

    public boolean isFree(float xa, float ya, float za) {
        AABB box = this.bb.cloneMove(xa, ya, za);
        Vector aABBs = this.level.getCubes(box);
        return aABBs.size() <= 0 && !this.level.containsAnyLiquid(box);
    }

    public void move(float xa, float ya, float za) {
        float xOrg = this.x;
        float zOrg = this.z;
        float xaOrg = xa;
        float yaOrg = ya;
        float zaOrg = za;
        Vector aABBs = this.level.getCubes(this.bb.expand(xa, ya, za));
        int i = 0;
        while (i < aABBs.size()) {
            ya = ((AABB)aABBs.elementAt(i)).clipYCollide(this.bb, ya);
            ++i;
        }
        this.bb.move(0.0f, ya, 0.0f);
        i = 0;
        while (i < aABBs.size()) {
            xa = ((AABB)aABBs.elementAt(i)).clipXCollide(this.bb, xa);
            ++i;
        }
        this.bb.move(xa, 0.0f, 0.0f);
        i = 0;
        while (i < aABBs.size()) {
            za = ((AABB)aABBs.elementAt(i)).clipZCollide(this.bb, za);
            ++i;
        }
        this.bb.move(0.0f, 0.0f, za);
        this.x = (this.bb.x0 + this.bb.x1) / 2.0f;
        this.y = this.bb.y0 + this.heightOffset;
        this.z = (this.bb.z0 + this.bb.z1) / 2.0f;
        this.horizontalCollision = xaOrg != xa || zaOrg != za;
        boolean bl = this.onGround = yaOrg != ya && yaOrg < 0.0f;
        if (this.onGround) {
            if (this.fallDistance > 0.0f) {
                this.causeFallDamage(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (ya < 0.0f) {
            this.fallDistance -= ya;
        }
        if (xaOrg != xa) {
            this.xd = 0.0f;
        }
        if (yaOrg != ya) {
            this.yd = 0.0f;
        }
        if (zaOrg != za) {
            this.zd = 0.0f;
        }
        float deltaX = this.x - xOrg;
        float deltaZ = this.z - zOrg;
        this.walkDist += (float)((double)Mth.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 0.6);
        boolean inWater = this.isInWater();
        if (this.level.containsFireTile(this.bb)) {
            this.burn(1);
            if (!inWater) {
                ++this.onFire;
                if (this.onFire == 0) {
                    this.onFire = 300;
                }
            }
        } else if (this.onFire <= 0) {
            this.onFire = -this.flameTime;
        }
        if (inWater && this.onFire > 0) {
            this.onFire = -this.flameTime;
        }
    }

    public void burn(int i) {
        this.hurt(null, i);
    }

    public void causeFallDamage(float dist) {
    }

    public boolean isInWater() {
        return this.level.containsLiquid(this.bb.grow(0.0f, -0.4f, 0.0f), 1);
    }

    public boolean isUnderWater() {
        int id = this.level.getTile((int)this.x, (int)(this.y + this.getHeadHeight()), (int)this.z);
        if (id != 0) {
            return Tile.tiles[id].getLiquidType() == 1;
        }
        return false;
    }

    public float getHeadHeight() {
        return 0.0f;
    }

    public boolean isInLava() {
        return this.level.containsLiquid(this.bb.grow(0.0f, -0.4f, 0.0f), 2);
    }

    public void moveRelative(float xa, float za, float speed) {
        float dist = Mth.sqrt(xa * xa + za * za);
        if (dist < 0.01f) {
            return;
        }
        if (dist < 1.0f) {
            dist = 1.0f;
        }
        dist = speed / dist;
        float sin = Mth.sin(this.yRot * (float)Math.PI / 180.0f);
        float cos = Mth.cos(this.yRot * (float)Math.PI / 180.0f);
        this.xd += (xa *= dist) * cos - (za *= dist) * sin;
        this.zd += za * cos + xa * sin;
    }

    public boolean hurt(Entity e, int i) {
        return false;
    }

    public int getRender() {
        return 0;
    }
}

