/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft;

import util.Mth;

public class Vec3 {
    public float x;
    public float y;
    public float z;

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3 add(float x, float y, float z) {
        return new Vec3(this.x + x, this.y + y, this.z + z);
    }

    public final float distanceTo(Vec3 a) {
        float n = a.x - this.x;
        float n2 = a.y - this.y;
        float n3 = a.z - this.z;
        return Mth.sqrt(n * n + n2 * n2 + n3 * n3);
    }

    public final float distanceToSqr(Vec3 a) {
        float n = a.x - this.x;
        float n2 = a.y - this.y;
        float n3 = a.z - this.z;
        return n * n + n2 * n2 + n3 * n3;
    }

    public final Vec3 clipX(Vec3 a, float float2) {
        float n = a.x - this.x;
        float n2 = a.y - this.y;
        float n3 = a.z - this.z;
        if (n * n < 1.0E-7f) {
            return null;
        }
        if ((float2 = (float2 - this.x) / n) < 0.0f || float2 > 1.0f) {
            return null;
        }
        return new Vec3(this.x + n * float2, this.y + n2 * float2, this.z + n3 * float2);
    }

    public final Vec3 clipY(Vec3 a, float float2) {
        float n = a.x - this.x;
        float n2 = a.y - this.y;
        float n3 = a.z - this.z;
        if (n2 * n2 < 1.0E-7f) {
            return null;
        }
        if ((float2 = (float2 - this.y) / n2) < 0.0f || float2 > 1.0f) {
            return null;
        }
        return new Vec3(this.x + n * float2, this.y + n2 * float2, this.z + n3 * float2);
    }

    public final Vec3 clipZ(Vec3 a, float float2) {
        float f;
        float n = a.x - this.x;
        float n2 = a.y - this.y;
        float n3 = a.z - this.z;
        if (f * n3 < 1.0E-7f) {
            return null;
        }
        if ((float2 = (float2 - this.z) / n3) < 0.0f || float2 > 1.0f) {
            return null;
        }
        return new Vec3(this.x + n * float2, this.y + n2 * float2, this.z + n3 * float2);
    }
}

