/*
 * Decompiled with CFR 0.152.
 */
package net.enderkitty.mobilecraft;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;
import javax.microedition.midlet.MIDlet;
import net.enderkitty.mobilecraft.HitResult;
import net.enderkitty.mobilecraft.Input;
import net.enderkitty.mobilecraft.Options;
import net.enderkitty.mobilecraft.Timer;
import net.enderkitty.mobilecraft.User;
import net.enderkitty.mobilecraft.Vec3;
import net.enderkitty.mobilecraft.entity.Entity;
import net.enderkitty.mobilecraft.entity.player.Player;
import net.enderkitty.mobilecraft.gamemode.CreativeMode;
import net.enderkitty.mobilecraft.gamemode.GameMode;
import net.enderkitty.mobilecraft.gamemode.SurvivalMode;
import net.enderkitty.mobilecraft.gui.CreativeScreen;
import net.enderkitty.mobilecraft.gui.DeathScreen;
import net.enderkitty.mobilecraft.gui.Gui;
import net.enderkitty.mobilecraft.gui.PauseScreen;
import net.enderkitty.mobilecraft.gui.Screen;
import net.enderkitty.mobilecraft.gui.TitleScreen;
import net.enderkitty.mobilecraft.item.Item;
import net.enderkitty.mobilecraft.item.ItemInstance;
import net.enderkitty.mobilecraft.level.Level;
import net.enderkitty.mobilecraft.level.tile.Tile;
import net.enderkitty.mobilecraft.renderer.Chunk;
import net.enderkitty.mobilecraft.renderer.LevelRenderer;
import net.enderkitty.mobilecraft.renderer.Textures;
import net.enderkitty.mobilecraft.renderer.entity.EntityRenderer;
import net.enderkitty.util.Util2;
import util.Mth;

public class Minecraft
extends GameCanvas
implements Runnable {
    public static final String VERSION_STRING = "J2MC v0.5b2";
    public MIDlet midlet;
    public Display disp;
    public Font font;
    public Font font_big;
    public Graphics gfx;
    public Graphics3D gfx3D;
    public Camera cam;
    public Background bck;
    public Transform tform;
    public int btn;
    public GameMode gameMode;
    public int width;
    public int height;
    Timer timer = new Timer(20.0f);
    public Level level;
    public LevelRenderer levelRenderer;
    public Player player;
    public User user;
    public boolean pause;
    public Screen screen;
    public Gui gui;
    public HitResult hitResult = null;
    public Options options;
    boolean running = false;
    public String fpsString = "";

    public Minecraft() {
        super(false);
    }

    public void createMinecraft() {
        if (!this.running) {
            this.setFullScreenMode(true);
            this.gfx = this.getGraphics();
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.disp = Display.getDisplay((MIDlet)this.midlet);
            Input.init();
            Thread t = new Thread(this);
            t.start();
        }
    }

    public void initGame() {
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.font_big = Font.getFont((int)0, (int)1, (int)16);
        this.disp.setCurrent((Displayable)this);
        this.gfx.setFont(this.font);
        this.gfx3D = Graphics3D.getInstance();
        this.cam = new Camera();
        this.cam.setPerspective(70.0f, (float)this.width / (float)this.height, 0.125f, 128.0f);
        this.bck = new Background();
        this.tform = new Transform();
        this.options = new Options(this);
        Textures.initTex();
        EntityRenderer.initAll();
        if (this.user == null) {
            this.user = new User("Player", "1a2b3c4d5e6f");
        }
        this.gameMode = new GameMode(this);
        if (this.level == null) {
            this.setScreen(new TitleScreen());
        }
        this.gui = new Gui(this);
    }

    public void startNewGame(int mode) {
        if (mode == 0) {
            this.gameMode = new SurvivalMode(this);
        }
        if (mode == 1) {
            this.gameMode = new CreativeMode(this);
        }
        this.level = new Level();
        if (mode == 1) {
            this.generateFlat(this.level, 32, 32, 32);
        } else {
            this.generateTest(this.level, 32, 32, 32);
        }
        this.levelRenderer = new LevelRenderer();
        this.levelRenderer.setLevel(this.level);
        this.level.addListener(this.levelRenderer);
        this.player = new Player(this.level);
        this.player.setPos(16.0162f, 19.0f, 16.0162f);
        this.level.addEntity(this.player);
        this.levelRenderer.checkBuild();
        if (mode == 0) {
            this.level.creativeMode = false;
            this.player.inventory.items[0] = new ItemInstance(Tile.cloth.id, 64);
            this.player.inventory.items[1] = new ItemInstance(Item.dstick.id, 1);
            this.player.inventory.items[2] = new ItemInstance(Tile.tnt.id, 64);
            this.player.inventory.items[3] = new ItemInstance(Item.apple.id, 64);
        }
        if (mode == 1) {
            this.level.creativeMode = true;
            this.player.inventory.items[0] = new ItemInstance(Tile.rock.id, 1);
            this.player.inventory.items[1] = new ItemInstance(Tile.stoneBrick.id, 1);
            this.player.inventory.items[2] = new ItemInstance(Tile.redBrick.id, 1);
            this.player.inventory.items[3] = new ItemInstance(Tile.wood.id, 1);
        }
    }

    public void generateFlat(Level lvl, int w, int h, int d) {
        byte[] blocks = new byte[w * h * d];
        int ix = 0;
        while (ix < w) {
            int iy = 0;
            while (iy < d) {
                int iz = 0;
                while (iz < h) {
                    int indx = (iy * h + iz) * w + ix;
                    int id = 0;
                    if (iy == 16) {
                        id = Tile.grass.id;
                    }
                    if (iy < 16) {
                        id = Tile.dirt.id;
                    }
                    if (iy < 14) {
                        id = Tile.rock.id;
                    }
                    if (iy == 0) {
                        id = Tile.unbreakable.id;
                    }
                    blocks[indx] = (byte)id;
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        lvl.setData(w, d, h, blocks);
    }

    public void generateTest(Level lvl, int w, int h, int d) {
        byte[] blocks = new byte[w * h * d];
        int ix = 0;
        while (ix < w) {
            int iy = 0;
            while (iy < d) {
                int iz = 0;
                while (iz < h) {
                    int indx = (iy * h + iz) * w + ix;
                    int id = 0;
                    if (iy == 16) {
                        id = Tile.grass.id;
                    }
                    if (iy < 16) {
                        id = Tile.dirt.id;
                    }
                    if (iy < 14) {
                        id = Tile.rock.id;
                    }
                    if (iy == 0) {
                        id = Tile.unbreakable.id;
                    }
                    if (iy < 17 && iy > 13 && ix < 26 && ix > 19 && iz < 26 && iz > 19) {
                        id = Tile.calmWater.id;
                        if (iy == 14) {
                            id = Tile.gravel.id;
                        }
                    }
                    blocks[indx] = (byte)id;
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        lvl.setData(w, d, h, blocks);
        int i = 0;
        while (i < 32) {
            if (Tile.tiles[i] != null) {
                this.level.setTileNoUpdate(i, 17, 8, i);
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            if (Tile.tiles[i + 32] != null) {
                this.level.setTileNoUpdate(i, 17, 5, i + 32);
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            this.level.setTileNoUpdate(i, 17, 2, Tile.cloth.id);
            this.level.setData(i, 17, 2, i);
            ++i;
        }
        this.spawnTest(8, 17, 24, Tile.tnt.id);
    }

    public void spawnTest(int x, int y, int z, int id) {
        this.level.setTile(x - 1, y, z - 1, id);
        this.level.setTile(x, y, z - 1, id);
        this.level.setTile(x + 1, y, z - 1, id);
        this.level.setTile(x - 1, y, z, id);
        this.level.setTile(x, y, z, id);
        this.level.setTile(x + 1, y, z, id);
        this.level.setTile(x - 1, y, z + 1, id);
        this.level.setTile(x, y, z + 1, id);
        this.level.setTile(x + 1, y, z + 1, id);
        this.level.setTile(x, y + 1, z, id);
    }

    public void setScreen(Screen scrn) {
        if (this.screen != null) {
            this.screen.removed();
        }
        if (scrn == null && this.level == null) {
            scrn = new TitleScreen();
        } else if (scrn == null && this.player.health <= 0) {
            scrn = new DeathScreen();
        }
        this.screen = scrn;
        if (this.screen != null) {
            Input.clear();
            this.screen.init(this, 240, 320);
        }
    }

    public void run() {
        this.running = true;
        try {
            this.initGame();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.drawCrash("Crash while init:", e);
        }
        long lastTime = System.currentTimeMillis();
        int frames = 0;
        while (this.running) {
            if (this.pause) {
                float ao = this.timer.a;
                this.timer.advanceTime();
                this.timer.a = ao;
            } else {
                this.timer.advanceTime();
            }
            int i = 0;
            while (i < this.timer.ticks) {
                this.tick();
                Input.updatePrev();
                ++i;
            }
            this.render(this.timer.a);
            ++frames;
            this.pause = this.screen != null && this.screen.isPauseScreen();
            while (System.currentTimeMillis() >= lastTime + 1000L) {
                this.fpsString = String.valueOf(frames) + " fps, " + Chunk.updates + " chunk updates";
                Chunk.updates = 0;
                lastTime += 1000L;
                frames = 0;
            }
        }
    }

    public void handleMouseClick(int var0) {
        ItemInstance selected;
        if (var0 == 1 && (selected = this.player.inventory.getSelected()) != null) {
            int oldCount = selected.count;
            ItemInstance newItm = selected.getItem().use(selected, this.level, this.player);
            if (newItm != selected || newItm != null && newItm.count != oldCount) {
                this.player.inventory.items[this.player.inventory.selected] = newItm;
                if (newItm.count == 0) {
                    this.player.inventory.items[this.player.inventory.selected] = null;
                }
            }
        }
        if (this.hitResult != null && this.hitResult.type == 0) {
            int x = this.hitResult.x;
            int y = this.hitResult.y;
            int z = this.hitResult.z;
            int f = this.hitResult.f;
            if (var0 == 0) {
                Tile oldTile = Tile.tiles[this.level.getTile(x, y, z)];
                boolean changed = this.level.setTile(x, y, z, 0);
                if (oldTile != null && changed) {
                    oldTile.destroy(this.level, x, y, z);
                }
            } else {
                ItemInstance selected2 = this.player.inventory.getSelected();
                if (selected2 == null) {
                    return;
                }
                Item.items[selected2.id].useOn(selected2, this.level, x, y, z, f);
                if (selected2.count == 0) {
                    this.player.inventory.items[this.player.inventory.selected] = null;
                }
            }
        }
    }

    public void tick() {
        this.gui.tick();
        if (this.screen == null && this.player != null && this.player.health <= 0) {
            this.setScreen(null);
        }
        if (this.screen == null) {
            if (Input.keyPressed(49) || Input.keyPressed(250)) {
                this.handleMouseClick(0);
            }
            if (Input.keyPressed(51) || Input.keyPressed(249)) {
                this.handleMouseClick(1);
            }
            if (Input.keyPressed(251)) {
                this.setScreen(new PauseScreen());
            }
            if (Input.keyPressed(this.options.keyInv.key) && this.level.creativeMode) {
                this.setScreen(new CreativeScreen());
            }
            if (Input.keyPressed(42)) {
                this.player.inventory.selected = this.player.inventory.selected - 1 & 3;
            }
            if (Input.keyPressed(35)) {
                this.player.inventory.selected = this.player.inventory.selected + 1 & 3;
            }
        }
        if (this.screen != null) {
            int keyPressed = Input.getCurrentPressed();
            if (keyPressed != -1) {
                this.screen.keyPressed(keyPressed);
            }
            if (this.screen != null) {
                this.screen.tick();
            }
        }
        int i = 0;
        while (i < 256) {
            if (Input.input[i]) {
                this.btn = i;
            }
            ++i;
        }
        if (this.level != null) {
            if (!this.pause) {
                this.level.tickEntities();
            }
            if (!this.pause) {
                this.level.tick();
            }
        }
        if (!this.pause && this.screen == null && this.player != null) {
            this.turnPlayer();
        }
    }

    public void turnPlayer() {
        if (Input.isKeyDown(this.getKeyCode(2))) {
            this.player.turn(-30.0f, 0.0f);
        }
        if (Input.isKeyDown(this.getKeyCode(5))) {
            this.player.turn(30.0f, 0.0f);
        }
        if (Input.isKeyDown(this.getKeyCode(1))) {
            this.player.turn(0.0f, 30.0f);
        }
        if (Input.isKeyDown(this.getKeyCode(6))) {
            this.player.turn(0.0f, -30.0f);
        }
    }

    public void tickPlayerOld() {
        this.player.tick();
        if (Input.isKeyDown(this.getKeyCode(2))) {
            this.player.turn(-30.0f, 0.0f);
        }
        if (Input.isKeyDown(this.getKeyCode(5))) {
            this.player.turn(30.0f, 0.0f);
        }
        if (Input.isKeyDown(this.getKeyCode(1))) {
            this.player.turn(0.0f, 30.0f);
        }
        if (Input.isKeyDown(this.getKeyCode(6))) {
            this.player.turn(0.0f, -30.0f);
        }
        float xa = 0.0f;
        float ya = 0.0f;
        boolean inWater = this.player.isInWater();
        boolean inLava = this.player.isInLava();
        if (Input.isKeyDown(50)) {
            ya -= 1.0f;
        }
        if (Input.isKeyDown(56)) {
            ya += 1.0f;
        }
        if (Input.isKeyDown(52)) {
            xa -= 1.0f;
        }
        if (Input.isKeyDown(54)) {
            xa += 1.0f;
        }
        if (Input.isKeyDown(53)) {
            if (inWater) {
                this.player.yd += 0.04f;
            } else if (inLava) {
                this.player.yd += 0.04f;
            } else if (this.player.onGround) {
                this.player.yd = 0.42f;
            }
        }
        this.player.travel(xa, ya);
    }

    public void bobHurt(float a) {
        float hurtDir;
        Player player = this.player;
        float sin = (float)player.hurtTime - a;
        if (player.health <= 0) {
            hurtDir = (float)player.deathTime + a;
            this.tform.postRotate(40.0f - 8000.0f / (hurtDir + 200.0f), 0.0f, 0.0f, 1.0f);
        }
        if (sin >= 0.0f) {
            sin /= (float)player.hurtDuration;
            sin = Mth.sin(sin * sin * sin * sin * (float)Math.PI);
            hurtDir = player.hurtDir;
            this.tform.postRotate(-hurtDir, 0.0f, 1.0f, 0.0f);
            this.tform.postRotate(-sin * 14.0f, 0.0f, 0.0f, 1.0f);
            this.tform.postRotate(hurtDir, 0.0f, 1.0f, 0.0f);
        }
    }

    public void bobView(float a) {
        Player player = this.player;
        float n = player.walkDist + (player.walkDist - player.walkDistO) * a;
        float n2 = player.oBob + (player.bob - player.oBob) * a;
        float n3 = player.oTilt + (player.tilt - player.oTilt) * a;
        this.tform.postTranslate(Mth.sin(n * (float)Math.PI) * n2 * 0.5f, -Math.abs(Mth.cos(n * (float)Math.PI) * n2), 0.0f);
        this.tform.postRotate(Mth.sin(n * (float)Math.PI) * n2 * 3.0f, 0.0f, 0.0f, 1.0f);
        this.tform.postRotate(Math.abs(Mth.cos(n * (float)Math.PI + 0.2f) * n2) * 5.0f, 1.0f, 0.0f, 0.0f);
        this.tform.postRotate(n3, 1.0f, 0.0f, 0.0f);
    }

    public void moveCameraToPlayer(float a) {
        Transform transform = new Transform();
        this.gfx3D.setCamera(this.cam, transform);
        float xRot = this.player.xRotO + (this.player.xRot - this.player.xRotO) * a;
        float yRot = this.player.yRotO + (this.player.yRot - this.player.yRotO) * a;
        this.tform.postRotate(xRot, 1.0f, 0.0f, 0.0f);
        this.tform.postRotate(yRot, 0.0f, 1.0f, 0.0f);
        float rx = this.player.xo + (this.player.x - this.player.xo) * a;
        float ry = this.player.yo + (this.player.y - this.player.yo) * a;
        float rz = this.player.zo + (this.player.z - this.player.zo) * a;
        this.tform.postTranslate(-rx, -ry, -rz);
    }

    public Vec3 getCamVector(float a) {
        float rx = this.player.xo + (this.player.x - this.player.xo) * a;
        float ry = this.player.yo + (this.player.y - this.player.yo) * a;
        float rz = this.player.zo + (this.player.z - this.player.zo) * a;
        return new Vec3(rx, ry, rz);
    }

    public void pick(float a) {
        float pitch = this.player.xRotO + (this.player.xRot - this.player.xRotO) * a;
        float yaw = this.player.yRotO + (this.player.yRot - this.player.yRotO) * a;
        Vec3 cam_pos = this.getCamVector(a);
        float cosYaw = Mth.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float sinYaw = Mth.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float cosPitch = Mth.cos(-pitch * ((float)Math.PI / 180));
        float dirY = Mth.sin(-pitch * ((float)Math.PI / 180));
        float dirX = sinYaw * cosPitch;
        float dirZ = cosYaw * cosPitch;
        float reachDist = this.gameMode.getPickRange();
        Vec3 end_pos = cam_pos.add(dirX * reachDist, dirY * reachDist, dirZ * reachDist);
        this.hitResult = this.level.clip(cam_pos, end_pos);
    }

    public void renderEntities(float a) {
        int i = 0;
        while (i < this.level.entities.size()) {
            Entity e = (Entity)this.level.entities.elementAt(i);
            EntityRenderer r = EntityRenderer.renderers[e.getRender()];
            if (r != null) {
                r.render(e, a, this.gfx3D, this.tform);
            }
            ++i;
        }
    }

    public void render(float a) {
        if (this.level != null) {
            this.levelRenderer.checkBuild();
            this.pick(a);
            this.gfx3D.bindTarget((Object)this.gfx, true, 0);
            this.bck.setColor(-8404993);
            this.gfx3D.clear(this.bck);
            this.tform.setIdentity();
            this.bobHurt(a);
            if (this.options.bobView) {
                this.bobView(a);
            }
            this.moveCameraToPlayer(a);
            this.levelRenderer.render(this.gfx3D, this.tform);
            this.renderEntities(a);
            this.gfx3D.releaseTarget();
        }
        this.drawGui(a);
        this.flushGraphics();
    }

    public void drawGui(float a) {
        if (this.level != null) {
            this.gui.render(a);
            this.gfx.setColor(0xFFFFFF);
            this.gfx.drawString(VERSION_STRING, 2, 2, 0);
            this.gfx.drawString(this.fpsString, 2, 18, 0);
            this.gfx.drawString("x: " + this.player.x, 2, 50, 0);
            this.gfx.drawString("y: " + this.player.y, 2, 66, 0);
            this.gfx.drawString("z: " + this.player.z, 2, 82, 0);
            this.gfx.drawString("Key: " + Util2.byteToHex(this.btn) + "h", 2, 130, 0);
            if (this.hitResult != null && this.hitResult.type == 0) {
                this.gfx.drawString("f: " + this.hitResult.f, 2, 146, 0);
            }
        } else {
            this.gfx.setColor(0);
            this.gfx.fillRect(0, 0, this.width, this.height);
            this.gfx.setColor(0xFFFFFF);
        }
        if (this.screen != null) {
            this.screen.render();
        }
    }

    public void drawCrash(String str, Throwable t) {
        while (true) {
            this.gfx.setColor(0);
            this.gfx.fillRect(0, 0, this.width, this.height);
            this.gfx.setColor(0xFFFFFF);
            this.gfx.drawString(str, 2, 2, 0);
            this.gfx.drawString(t.toString(), 2, 18, 0);
            this.flushGraphics();
        }
    }

    public void keyPressed(int code) {
        Input.input[code & 0xFF] = true;
    }

    public void keyReleased(int code) {
        Input.input[code & 0xFF] = false;
    }
}

